/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.events.extra.ExtraEventHandler;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.accessories.pond.AccessoriesAPIAccess;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import java.util.Map;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements AccessoriesAPIAccess,
AccessoriesLivingEntityExtension {
    protected LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    @Nullable
    public AccessoriesCapability accessoriesCapability() {
        Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots((class_1309)this);
        if (slots.isEmpty()) {
            return null;
        }
        return new AccessoriesCapabilityImpl((class_1309)this);
    }

    @Override
    @Nullable
    public AccessoriesHolder accessoriesHolder() {
        AccessoriesCapability capability = this.accessoriesCapability();
        return capability != null ? capability.getHolder() : null;
    }

    @Inject(method={"onEquippedItemBroken"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendAccessoriesBreakInstead(class_1792 item, class_1304 slot, CallbackInfo ci) {
        if (slot.equals((Object)AccessoriesInternals.INTERNAL_SLOT)) {
            ci.cancel();
        }
    }

    @Inject(method={"entityEventForEquipmentBreak"}, at={@At(value="HEAD")}, cancellable=true)
    private static void preventMatchExceptionForAccessories(class_1304 slot, CallbackInfoReturnable<Byte> cir) {
        if (slot.equals((Object)AccessoriesInternals.INTERNAL_SLOT)) {
            cir.setReturnValue((Object)-1);
        }
    }

    @Override
    public void onEquipItem(SlotReference slotReference, class_1799 oldItem, class_1799 newItem) {
        class_1937 level = this.method_37908();
        if (!(class_1799.method_31577((class_1799)oldItem, (class_1799)newItem) || this.field_5953 || level.method_8608() || this.method_7325())) {
            SoundEventData sound;
            boolean isEquitableFor;
            boolean bl = isEquitableFor = newItem.method_7960() || AccessoriesAPI.canInsertIntoSlot(newItem, slotReference);
            if (!this.method_5701() && !newItem.method_7960() && (sound = AccessoriesAPI.getOrDefaultAccessory(newItem).getEquipSound(newItem, slotReference)) != null) {
                level.method_47967(null, this.method_23317(), this.method_23318(), this.method_23321(), (class_3414)sound.event().comp_349(), this.method_5634(), sound.volume(), sound.pitch(), this.field_5974.method_43055());
            }
            if (isEquitableFor) {
                this.method_32876((class_6880)(!newItem.method_7960() ? class_5712.field_28739 : class_5712.field_45787));
            }
        }
    }

    @ModifyReturnValue(method={"canFreeze"}, at={@At(value="RETURN", ordinal=1)})
    private boolean canFreezeAccessoriesCheck(boolean bl) {
        TriState state = ExtraEventHandler.canFreezeEntity((class_1309)this);
        return state.orElse(bl);
    }
}

